<?xml version="1.0" encoding="UTF-8"?>
<!-- 
####################################################################################
#  XSL name : section6
#  Version : R2.0.9.S01                                        
#  Intermediate release number : 014-20161025                                   
#  Last update : 03/06/2016                                                            
####################################################################################
 -->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0"  xmlns:ted="http://formex.publications.europa.eu/ted/schema/reception/R2.0.9.S01" exclude-result-prefixes="ted">
	<!---->
	<xsl:template match="ted:EORDERING|ted:EINVOICING|ted:EPAYMENT" mode="R700R701R702R703R704">
		<xsl:variable name="ele" select="concat('NOTICE/@TYPE=', ancestor::*[@FORM]//ted:NOTICE/@*,' and ',local-name(.))"/>
		<xsl:choose>
			<xsl:when test="not(ancestor::*[@FORM]//ted:NOTICE) or ancestor::*[@FORM='F07']"/>
			<xsl:when test="ancestor::*[@FORM]//ted:NOTICE[@*='PRI_ONLY']">
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R700'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="ancestor::*[@FORM]//ted:NOTICE[@*='PER_ONLY']">
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R701'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="ancestor::*[@FORM]//ted:NOTICE[@*='AWARD_CONTRACT']">
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R702'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="ancestor::*[@FORM]//ted:NOTICE[@*='QSU_ONLY' or @*='QSU_CALL_COMPETITION']">
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R703'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="ancestor::*[@FORM]//ted:NOTICE[@*='CONCESSION_AWARD_CONTRACT']">
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R704'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<!---->
	<xsl:template match="ted:ADDRESS_REVIEW_BODY|ted:ADDRESS_MEDIATION_BODY|ted:REVIEW_PROCEDURE|ted:ADDRESS_REVIEW_INFO" mode="R705R706">
		<xsl:variable name="ele" select="concat('NOTICE/@TYPE=', ancestor::*[@FORM]//ted:NOTICE/@*,' and ',local-name(.))"/>
		<xsl:choose>
			<xsl:when test="not(ancestor::*[@FORM]//ted:NOTICE) or ancestor::*[@FORM='F07']"/>
			<xsl:when test="ancestor::*[@FORM]//ted:NOTICE[@*='PRI_ONLY']">
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R705'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="ancestor::*[@FORM]//ted:NOTICE[@*='PER_ONLY']">
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R706'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM='F01' or @FORM='F04'][.//ted:NOTICE[@*!='PRI_ONLY' and @*!='PER_ONLY'] and not(.//ted:ADDRESS_REVIEW_BODY)]" mode="R707">
		<xsl:variable name="ele" select="concat('NOTICE/@TYPE=', .//ted:NOTICE/@*,' and missing ADDRESS_REVIEW_BODY')"/>
		<xsl:call-template name="msg">
			<xsl:with-param name="rule" select="'R707'"/>
			<xsl:with-param name="content" select="$ele"/>
		</xsl:call-template>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM='F14'][number(replace(.//ted:DATE_DISPATCH_ORIGINAL/text(),'-','')) &gt; number(replace(.//ted:DATE_DISPATCH_NOTICE/text(),'-',''))]" mode="R708">
		<xsl:variable name="ele" select="concat('DATE_DISPATCH_ORIGINAL=',.//ted:DATE_DISPATCH_ORIGINAL/text(),', DATE_DISPATCH_NOTICE=',.//ted:DATE_DISPATCH_NOTICE/text())"/>
		<xsl:call-template name="msg">
			<xsl:with-param name="rule" select="'R708'"/>
			<xsl:with-param name="content" select="$ele"/>
		</xsl:call-template>
	</xsl:template>
	<!---->
	<xsl:template match="ted:DATE_DISPATCH_NOTICE" mode="R709">
		<xsl:if test="not(matches(normalize-space(text()),'^20'))">
			<xsl:call-template name="msg">
				<xsl:with-param name="rule" select="'R709'"/>
				<xsl:with-param name="content" select="concat(local-name(.),'=', &quot;'&quot;, normalize-space(./text()), &quot;'&quot;)"/>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
</xsl:stylesheet>
